package com.qboxus.tictic.viewModels

import android.content.Context
import android.content.SharedPreferences
import androidx.databinding.ObservableBoolean
import androidx.databinding.ObservableInt
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.viewModelScope
import com.qboxus.tictic.apiclasses.ApiResponce
import com.qboxus.tictic.models.UserModel
import com.qboxus.tictic.repositories.UserRepository
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.Variables
import kotlinx.coroutines.launch
import org.json.JSONObject

class ProfileViewsViewModel(
    private val context: Context,
    private val userRepository: UserRepository

) : ViewModel(){

    lateinit var sharedPreferences: SharedPreferences
    init {
        sharedPreferences=Functions.getSharedPreference(context)
    }

    var ispostFinsh = false
    var isApiRun = false


    var pageCount: ObservableInt = ObservableInt(0)

    val _listLiveData: MutableLiveData<ApiResponce<ArrayList<UserModel>>> = MutableLiveData()
    val listLiveData: LiveData<ApiResponce<ArrayList<UserModel>>> get() = _listLiveData

    fun getProfileViewsList(){
        viewModelScope.launch {

            val params = JSONObject()
            userRepository.getProfileVisitors(params,_listLiveData)

        }
    }


    val _followLiveData: MutableLiveData<ApiResponce<UserModel>> = MutableLiveData()
    val followLiveData: LiveData<ApiResponce<UserModel>> get() = _followLiveData
    fun followUser(userId:String){
        viewModelScope.launch {
            val param = JSONObject().apply {
                put("sender_id", sharedPreferences.getString(Variables.U_ID, "0"))
                put("receiver_id", userId)
            }
            userRepository.callApiFollowUser(param, _followLiveData)
        }
    }




    val _editProfileLiveData: MutableLiveData<ApiResponce<UserModel>> = MutableLiveData()
    val editProfileLiveData: LiveData<ApiResponce<UserModel>> get() = _editProfileLiveData

    fun updateProfileViewStatus(){
        viewModelScope.launch {
            val param = JSONObject().apply {
                put("auth_token", sharedPreferences.getString(Variables.AUTH_TOKEN, "0"))
                put("profile_view", "1")
            }
            userRepository.callApiEditProfile(param, _editProfileLiveData)
        }
    }



    var noDataLayoutVisibility = ObservableBoolean(false)
    var loadMoreProgressVisibility = ObservableBoolean(false)

    fun showNoDataView(){
        noDataLayoutVisibility.set(true)
    }

    fun showDataView(){
        noDataLayoutVisibility.set(false)
    }

}

class ProfileViewsFactory(
    private val context: Context,
    private val userRepository: UserRepository
) : ViewModelProvider.Factory {
    override fun <T : ViewModel> create(modelClass: Class<T>): T {
        if (modelClass.isAssignableFrom(ProfileViewsViewModel::class.java)) {
            return ProfileViewsViewModel(context,userRepository) as T
        }
        throw IllegalArgumentException("Unknown ViewModel class")
    }
}